<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Message extends Model 
{

    protected $table = 'messages';
    public $timestamps = true;
    protected $fillable = array('body', 'user_id', 'commentator_id');

    public function client()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function commentator()
    {
        return $this->belongsTo('App\Models\Commentator');
    }

}